<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'controllers/inbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Folder_controller extends Inbox {
	
	function __construct() {
		parent::__construct();
		$this->load->library('api');
	}	

    /** Archives all messages in a folder, then deletes the folder. */
    public function archive_folder($folder_name) {
		$this->load->library('mailformat');
        $folder_name = base64_decode(rawurldecode($folder_name));
		
		$folders = $this->mailformat->get_folder_list()->response;
		foreach($folders->folder as $folder) {
			if(CUSTOM_MAILBOX_PREFIX . $folder_name === $folder->name) { $folder_id = $folder->id; }
		}
		if(empty($folder_id)) { return $this->error->warning('Could not find a folder named '.$folder_name); }
		
		//construct post request
		$fields = array(
			'mailbox' => $this->mailbox->name,
			'folder' => $folder_id,
		);
		$this->api->clear();
		if($this->api->call('/direct/folders/archive', $fields, 'POST'))
			$this->session->set_success_message($folder_name.' folder has been successfully archived.');
		else
			$this->session->set_error_message('An error occured and the '.$folder_name.' folder was not archived.  Please try again in a moment, and contact an administrator if this problem persists.');
        
        //refresh mailbox list
        $_SESSION['mailbox_list'] = $this->mailformat->mailbox_list();
        redirect('inbox');
    }

	
	
	/** Displays the create folder form view, meant for use with a modal window or pop-up. */
	public function create_folder_form() {
		$this->load->view('inbox/create_folder_form');
	}	
    
     /**
	 * Renames IMAP folders that the user has created with this application.
     * The function will check for the prefix that the application attaches to custom folders so that it replaces only
     * custom folders. It accepts the new folder name as a post value from the jeditable editable input and the old folder name
     * as a parameter passed to the function.
     */
    function rename_folder($folder_str) {
		//decode parameters
		if(isset($folder_str)) {
			$folder_str = base64_decode(html_entity_decode(rawurldecode($folder_str)));
		}
		else { show_404(); return FALSE; }
		
        //figure out mailbox prefix
		$folder_prefix = CUSTOM_MAILBOX_PREFIX;
        $new_folder_str = $this->input->post('value',TRUE);
		if(strlen($new_folder_str) <= 0) { $new_folder_str = $this->input->post('value_'.hash('sha256',$folder_str),TRUE); }
		if(strlen($new_folder_str) <= 0) { show_404(); return FALSE; } //if still blank, throw 404
        
		$resource = '/direct/folders/rename/format/json';
		$folders = $this->mailformat->get_folder_list()->response;
		foreach($folders->folder as $folder) {
			if(CUSTOM_MAILBOX_PREFIX . $folder_str === $folder->name) { 
				$folder_id = $folder->id;
				if($folder->new > 0) {
					$show_unseen = ' ('.$folder->new.')'; 
				}else{
					$show_unseen = '';
				}
			}
		}
		if(empty($folder_id)) { return FALSE; }
		
		//construct post request
		$fields = array(
			'mailbox' => $this->mailbox->name,
			'folder' => $folder_id,
			'name' => $folder_prefix.$new_folder_str,
		);
		$post = '';
		foreach($fields as $key => $value) { $post .= $key.'='.urlencode($value).'&'; } //url-ify the data for the POST
		$post = rtrim($post, '&');
		
		$response = $this->api_model->webservice_call($resource,'POST',$post)->response;
		$success = isset($response->folder->id);
		if($success) {
			echo $this->build_rename_response('success', $folder_id, $folder_str, $new_folder_str, $folder_prefix, $show_unseen);
		}
		else if(isset($response->message) && strpos($response->message,'exists') > 0) {
			echo $this->build_rename_response('exists', $folder_id, $folder_str, $new_folder_str, $folder_prefix, $show_unseen);
		}
		else {
			echo $this->build_rename_response('failure', $folder_id, $folder_str, $new_folder_str, $folder_prefix, $show_unseen);
		}
        //refresh mailbox list
        $_SESSION['mailbox_list'] = $this->mailformat->mailbox_list();
    }

////////////////////////////////////
// PROTECTED HELPER METHODS
////////////////////////////////////

	protected function build_rename_response($response_type, $folder_id, $folder_str, $new_folder_str, $folder_prefix, $show_unseen) {
		$folder_str_id = hash('sha256',$folder_str);
		$js_safe_new_folder_str = str_replace("'","\'",$new_folder_str);
		$js_safe_folder_str = str_replace("'","\'",$folder_str);
		
		if($response_type === 'success') {
			return $new_folder_str .
				"<script>$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none'); ". //hide the span used for edit
					"$('#' + '" . $folder_str_id . "').parent().children('a').attr('title', '" . $new_folder_str . $show_unseen . "'); ". //change the title tooltip to new mailbox name
					"$('#' + '" . $folder_str_id . "').parent().children('a').attr('href', '".base_url() . 'inbox/change_mailbox/' . rawurlencode(base64_encode($folder_id))."'); ". //change link href to new mailbox link
					"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_new_folder_str . $show_unseen."'); " . //change link text to new mailbox name
					"$('#' + '" . $folder_str_id . "').parent().children('a').css('display', 'block'); ". //show the link again now that it is updated
					"$('#' + '" . $folder_str_id . "').parent().children('a').focus(); ".//focus on after change
					"$('#' + '" . $folder_str_id . "').attr('id','" . hash('sha256',$new_folder_str) . "'); ". //set the id of the overall list item that associates all these elements with the mailbox name
					//reset the onclick event for the hidden button in the accessibility menu to use new mailbox
					"$('#rename_folder_" . $folder_str_id . "').attr('onclick','".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').css(\'display\', \'inline\');".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'a\').css(\'display\', \'none\');".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').editable(\'/inbox/rename_folder/".
						rawurlencode(base64_encode($new_folder_str))."/\', { event : \'rename_event\', height: 12, width: 100, style : \'position: relative; float: right; z-index: 100;\', onblur : \'submit\',indicator : \'Saving...\', callback: function(value, settings) { $(this).unbind(settings.event);}}); ".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').trigger(\'rename_event\');".
					"');".
					"$('#rename_folder_" . $folder_str_id . "').attr('id', 'rename_folder_" . hash('sha256',$new_folder_str) . "'); ". //set the id of the button to use new mailbox hash
					"$('#archive_folder_" . $folder_str_id . "').attr('href', '/inbox/archive_folder/".rawurlencode(base64_encode($new_folder_str))."/'); ". //set the hidden archive folder link to use new mailbox
					"$('#archive_folder_" . $folder_str_id . "').html('Archive Folder: " . ($new_folder_str) . "'); ". //set hidden archive folder link to display new mailbox name
					"$('#archive_folder_" . $folder_str_id . "').attr('id', 'archive_folder_" . hash('sha256',$new_folder_str) . "'); ". //set new id for archive folder link using new mailbox hash
					"$('#rename_folder_label_" . $folder_str_id . "').attr('for', 'rename_folder_" . hash('sha256',$new_folder_str) . "'); ". //set label for the hidden button to use new id
					"$('#rename_folder_label_" . $folder_str_id . "').attr('id', 'rename_folder_label_" . hash('sha256',$new_folder_str) . "'); ". //set id for the label to use the new mailbox hash
				"</script>"; 
		}
		else if($response_type === 'exists') {
			return $folder_str . $show_unseen . 
					"<script>".
						"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none');". //hide the editable span
						"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_folder_str . $show_unseen."');". //change the inner HTML of the link back to what it was
						"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').html('".$js_safe_folder_str."');". //ensure hidden span has only the actual name
						"$('#' + '" . $folder_str_id . "').parent().children('a').css('display','block');". //show the link again
						"alert('A folder with this name already exists.');". //alert the user to the error
					"</script>";
		}
		else if($response_type === 'failure') {
			return $folder_str . $show_unseen . 
					"<script>".
						"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none');". //hide the editable span
						"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_folder_str . $show_unseen."');". //change the inner HTML of the link back to what it was
						"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').html('".$js_safe_folder_str."');". //ensure hidden span has only the actual name
						"$('#' + '" . $folder_str_id . "').parent().children('a').css('display','block');". //show the link again
						"alert('An error occurred renaming folder, folder not renamed.');". //alert the user to the error
					"</script>";
		}
	}

	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */